import { StarXpandCommand } from "star-io10-web";

export class ReceiptSample12_Lottery_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        .settingPrintableArea(72.0)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
            .styleLineSpace(3.0)
            .actionPrintImage(
              new StarXpandCommand.Printer.ImageParameter("logo_01.png", 400),
            )
            .actionFeedLine(1)
            .add(
              new StarXpandCommand.PrinterBuilder(
                new StarXpandCommand.Printer.PrinterParameter().setTemplateExtension(
                  new StarXpandCommand.TemplateExtensionParameter().setEnableArrayFieldData(
                    true,
                  ),
                ),
              )
                .styleBold(true)
                .actionPrintText(
                  "${item_list.header}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(1),
                )
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(2, 2),
                )
                .actionPrintText(
                  " ${item_list.number_1%02d}" +
                    " ${item_list.number_2%02d}" +
                    " ${item_list.number_3%02d}" +
                    " ${item_list.number_4%02d}" +
                    " ${item_list.number_5%02d}",
                )
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(1, 1),
                )
                .actionPrintText(" OP")
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(2, 2),
                )
                .actionPrintText(" ${item_list.number_6%02d}")
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(1, 1),
                )
                .actionPrintText(" OP\n"),
            )
            .actionFeedLine(1)
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleBold(true)
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(2, 2),
                )
                .actionPrintText("${winning_day}\n" + "$${price%.2f}\n"),
            )
            .actionFeedLine(1)
            .actionPrintText("${sales_number}\n" + "${datetime}\n")
            .actionFeedLine(1)
            .actionPrintText("${note}\n")
            .actionPrintBarcode(
              new StarXpandCommand.Printer.BarcodeParameter(
                "${barcode}",
                StarXpandCommand.Printer.BarcodeSymbology.Code128,
              ).setHeight(7.0),
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "item_list" : [
        {
            "header" : "A",
            "number_1" : 12,
            "number_2" : 23,
            "number_3" : 25,
            "number_4" : 53,
            "number_5" : 66,
            "number_6" : 24
        },
        {
            "header" : "B",
            "number_1" : 4,
            "number_2" : 22,
            "number_3" : 23,
            "number_4" : 60,
            "number_5" : 62,
            "number_6" : 11
        }
    ],
    "winning_day" : "WED JAN13 16",
    "price" : 4.0,
    "month" : 1,
    "sales_number" : "10211100 967-031722777-158629 012133",
    "datetime" : "SUN JAN10 16  14:40:07",
    "note" : "MEGA MILLIONS JACKPOT\\nNOW $15 MILLION.\\nRESULTS STAR-M.JP\\n",
    "barcode" : "0123456789012345678901234567890123456789"
}`,
    );
  }
}
